//
//  GHCustomAccelerometerSettings.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 8/29/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import "GHCustomSettings.h"

/**
 *  The GHCustomAccelerometerSettings class contains accelerometer settings values retrieved
 *  from a Garmin device or is used to to set new values on on the device.
 */
@interface GHCustomAccelerometerSettings : GHCustomSettings

/**
 * The number of sessions per day.
 */
@property (nonnull, nonatomic) NSNumber *sessionsPerDay;

/**
 * The number of pre collection intervals.
 */
@property (nonnull, nonatomic) NSNumber *preCollectionIntervals;

/**
 * The number of collection intervals.
 */
@property (nonnull, nonatomic) NSNumber *numberOfCollectionIntervals;

/**
 * The minimum number of steps per interval.
 */
@property (nonnull, nonatomic) NSNumber *minimumStepsPerInterval;

/**
 * The maxnimum number of steps per interval.
 */
@property (nonnull, nonatomic) NSNumber *maximumStepsPerInterval;

/**
 * The interval sample size.
 */
@property (nonnull, nonatomic) NSNumber *intervalSampleSize;


@end
